/*
 * Copyright (c) 1995 Eugene W. Stark
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Eugene W. Stark.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 5. No copying or redistribution in any form for commercial purposes is
 *    permitted without specific prior written permission.
 * 6. This software may be used, for evaluation purposes only, for a period
 *    of no more than fourteen days.  Use of the software for a period beyond
 *    fourteen days, or use of the software for anything other than evaluation
 *    purposes, requires written permission from the author.  Such permission
 *    may be obtained by paying to the author a registration fee,
 *    as described in the documentation accompanying this software.
 *
 * THIS SOFTWARE IS PROVIDED BY EUGENE W. STARK (THE AUTHOR) ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Default output templates
 */

#include <stdio.h>
#include "templates.h"

/*
 * The templates are split into several strings, because the
 * "stone knives and bearskins" Microsoft compiler has a limit on
 * the length of a string literal.
 *
 * The splitting is now used as a convenient way to substitute certain
 * option-dependent portions of the template, such as "../PERSONS.html" versus
 * "PERSONS.html"
 */

char *individual_template_base[] =
{
/* 0 */
  "<HTML>\n" \
  "<HEAD>\n" \
  "!IF @.TITLE\n" \
    "<TITLE>${@.XREF}: ${@.NAME} (${@.TITLE})\n" \
    " (${@.BIRTH.DATE} - ${@.DEATH.DATE})\n" \
    "</TITLE>\n" \
  "!ELSE\n" \
    "<TITLE>${@.XREF}: ${@.NAME}\n" \
    " (${@.BIRTH.DATE} - ${@.DEATH.DATE})\n" \
    "</TITLE>\n" \
  "!ENDIF\n" \
  "</HEAD>\n" \
  "<BODY>\n" \
  "!IF @.TITLE\n" \
    "<H1><A NAME=\"${@.XREF}\">${@.NAME} (${@.TITLE})</A></H1>\n" \
  "!ELSE\n" \
    "<H1><A NAME=\"${@.XREF}\">${@.NAME}</A></H1>\n" \
  "!ENDIF\n" \
  "!IF @.SOURCE\n" \
    "!RESET j\n" \
    "!WHILE @.SOURCE[j]\n" \
      "<A HREF=\"${@.SOURCE[j].SOURCE.&}\">[${@.SOURCE[j].SOURCE.XREF}]</A>\n" \
      "!INCREMENT j\n" \
    "!END\n" \
    "<BR>\n" \
  "!ENDIF\n"
#ifdef MSDOS
  "!INCLUDE ../@.img\n",
#else
  "!INCLUDE @.img\n",
#endif
/* 1 */
  "!IF @.EVENT\n" \
    "<UL>\n" \
    "!RESET i\n" \
    "!WHILE @.EVENT[i]\n" \
      "!IF @.EVENT[i].TEXT\n" \
          "<LI><EM>${@.EVENT[i].TAG}</EM>: ${@.EVENT[i].TEXT}\n" \
      "!ELSE\n" \
        "!IF @.EVENT[i].DATE\n" \
          "!IF @.EVENT[i].PLACE\n" \
            "<LI><EM>${@.EVENT[i].TAG}</EM>: ${@.EVENT[i].DATE}, ${@.EVENT[i].PLACE.NAME}\n" \
          "!ELSE\n" \
            "<LI><EM>${@.EVENT[i].TAG}</EM>: ${@.EVENT[i].DATE}\n" \
          "!ENDIF\n" \
        "!ELSE\n" \
          "!IF @.EVENT[i].PLACE\n" \
            "<LI><EM>${@.EVENT[i].TAG}</EM>: ${@.EVENT[i].PLACE.NAME}\n" \
          "!ELSE\n" \
            "<LI><EM>${@.EVENT[i].TAG}</EM>:\n" \
          "!ENDIF\n" \
        "!ENDIF\n" \
      "!ENDIF\n" \
      "!IF @.EVENT[i].SOURCE\n" \
        "!RESET j\n" \
        "!WHILE @.EVENT[i].SOURCE[j]\n" \
          "<A HREF=\"${@.EVENT[i].SOURCE[j].SOURCE.&}\">[${@.EVENT[i].SOURCE[j].SOURCE.XREF}]</A>\n" \
          "!INCREMENT j\n" \
        "!END\n" \
      "!ENDIF\n" \
      "!INCREMENT i\n" \
    "!END\n" \
    "</UL>\n" \
  "!ENDIF\n",
  
  /* 2 */
  "!IF @.ATTR\n" \
    "<UL>\n" \
    "!RESET i\n" \
    "!WHILE @.ATTR[i]\n" \
      "<LI><EM>${@.ATTR[i].TAG}</EM>: ${@.ATTR[i].TEXT}\n" \
      "!INCREMENT i\n" \
    "!END\n" \
    "</UL>\n" \
  "!ENDIF\n" \
  "!RESET br\n" \
  "!IF @.FATHER\n" \
    "!INCREMENT br\n" \
    "<EM>Father:</EM> <A HREF=\"${@.FATHER.&}\">${@.FATHER.NAME}</A><BR>\n" \
  "!ENDIF\n" \
  "!IF @.MOTHER\n" \
    "!INCREMENT br\n" \
    "<EM>Mother:</EM> <A HREF=\"${@.MOTHER.&}\">${@.MOTHER.NAME}</A><BR>\n" \
  "!ENDIF\n" \
  "!IF br\n" \
    "<BR>\n" \
  "!ENDIF\n" \
  "!RESET i\n" \
  "!WHILE @.FAMS[i]\n" \
    "<EM>Family ${i}</EM>:\n" \
    "!IF @.ISMALE\n" \
      "!IF @.FAMS[i].FAMILY.WIFE\n" \
        "<A HREF=\"${@.FAMS[i].FAMILY.WIFE.&}\">${@.FAMS[i].FAMILY.WIFE.NAME}</A>\n" \
      "!ENDIF\n" \
    "!ENDIF\n" \
    "!IF @.ISFEMALE\n" \
      "!IF @.FAMS[i].FAMILY.HUSBAND\n" \
        "<A HREF=\"${@.FAMS[i].FAMILY.HUSBAND.&}\">${@.FAMS[i].FAMILY.HUSBAND.NAME}</A>\n" \
      "!ENDIF\n" \
    "!ENDIF\n" \
    "!IF @.FAMS[i].FAMILY.SOURCE\n" \
      "<BR>\n" \
      "!RESET j\n" \
      "!WHILE @.FAMS[i].FAMILY.SOURCE[j]\n" \
        "<A HREF=\"${@.FAMS[i].FAMILY.SOURCE[j].SOURCE.&}\">[${@.FAMS[i].FAMILY.SOURCE[j].SOURCE.XREF}]</A>\n" \
        "!INCREMENT j\n" \
      "!END\n" \
    "!ENDIF\n" \
    "!IF @.FAMS[i].FAMILY.EVENT\n" \
      "<UL>\n" \
      "!RESET j\n" \
      "!WHILE @.FAMS[i].FAMILY.EVENT[j]\n" \
        "!IF @.FAMS[i].FAMILY.EVENT[j].TEXT\n" \
          "<LI><EM>${@.FAMS[i].FAMILY.EVENT[j].TAG}</EM>: ${@.FAMS[i].FAMILY.EVENT[j].TEXT}\n" \
        "!ELSE\n" \
	  "!IF @.FAMS[i].FAMILY.EVENT[j].DATE\n" \
	    "!IF @.FAMS[i].FAMILY.EVENT[j].PLACE\n" \
              "<LI><EM>${@.FAMS[i].FAMILY.EVENT[j].TAG}</EM>: ${@.FAMS[i].FAMILY.EVENT[j].DATE}, ${@.FAMS[i].FAMILY.EVENT[j].PLACE.NAME}\n" \
            "!ELSE\n" \
              "<LI><EM>${@.FAMS[i].FAMILY.EVENT[j].TAG}</EM>: ${@.FAMS[i].FAMILY.EVENT[j].DATE}\n" \
            "!ENDIF\n" \
          "!ELSE\n" \
             "<LI><EM>${@.FAMS[i].FAMILY.EVENT[j].TAG}</EM>: ${@.FAMS[i].FAMILY.EVENT[j].PLACE.NAME}\n" \
          "!ENDIF\n" \
        "!ENDIF\n" \
        "!INCREMENT j\n" \
      "!END\n" \
      "</UL>\n" \
    "!ELSE\n" \
      "<BR>\n" \
    "!ENDIF\n",

/* 3 */
    "!IF @.FAMS[i].FAMILY.CHILDREN\n" \
      "<OL>\n" \
      "!RESET j\n" \
      "!WHILE @.FAMS[i].FAMILY.CHILDREN[j]\n" \
        "<LI><A HREF=\"${@.FAMS[i].FAMILY.CHILDREN[j].INDIV.&}\">" \
        "${@.FAMS[i].FAMILY.CHILDREN[j].INDIV.NAME}</A>\n" \
        "!INCREMENT j\n" \
      "!END\n" \
      "</OL>\n" \
    "!ELSE\n" \
      "<BR>\n" \
    "!ENDIF\n" \
    "!INCREMENT i\n" \
  "!END\n",

/* 4 */  /* Pedigree diagram, if available */
  "!PEDIGREE @\n",

/* 5 */  /* This should be the value of INDEX_ANCHOR_POS in template.h */
  INDEX_ANCHOR_NOSUBDIR,
  
/* 6 */
  "<P>\n" \
  "!IF @.NOTE\n" \
    "<H2>Notes</H2>\n" \
    "!RESET i\n" \
    "!WHILE @.NOTE[i]\n" \
      "${@.NOTE[i].TEXT}\n" \
      "!RESET j\n" \
      "!WHILE @.NOTE[i].CONT[j]\n" \
        "!IF @.NOTE[i].CONT[j].BREAK\n" \
          "<BR>\n" \
        "!ENDIF\n" \
        "${@.NOTE[i].CONT[j].TEXT}\n" \
        "!INCREMENT j\n" \
      "!END\n" \
      "!RESET j\n" \
      "!WHILE @.NOTE[i].SOURCE[j]\n" \
        "<A HREF=\"${@.NOTE[i].SOURCE[j].SOURCE.&}\">[${@.NOTE[i].SOURCE[j].SOURCE.XREF}]</A>\n" \
        "!INCREMENT j\n" \
      "!END\n" \
      "<P>\n" \
      "!INCREMENT i\n" \
    "!END\n" \
  "!ENDIF\n"
#ifdef MSDOS
  "!INCLUDE ../@.inc\n"
#else
  "!INCLUDE @.inc\n"
#endif
  "<HR><EM>Created by \n" \
  "!VERSION\n" \
  "on \n" \
  "!DATE\n" \
  "</EM>\n" \
  "</BODY>\n" \
  "</HTML>\n"
  };

int individual_template_base_size =
  sizeof(individual_template_base)/sizeof(char *);

char *individual_template = NULL;

char *source_template =
  "<HTML>\n<HEAD>\n<TITLE>Sources</TITLE>\n</HEAD>\n" \
  "<BODY>\n<H2>Sources</H2>\n" \
  "!WHILE @\n" \
    "<A NAME=\"${@.XREF}\">[${@.XREF}]</A>\n" \
    "${@.TEXT}\n" \
    "!RESET j\n" \
    "!WHILE @.CONT[j]\n" \
      "!IF @.CONT[j].BREAK\n" \
        "<BR>\n" \
      "!ENDIF\n" \
      "${@.CONT[j].TEXT}\n" \
      "!INCREMENT j\n" \
    "!END\n" \
    "!RESET j\n" \
    "!WHILE @.NOTE[j]\n" \
      "${@.NOTE[j].TEXT\n" \
      "!RESET k\n" \
	"!WHILE @.NOTE[j].CONT[k]\n" \
          "!IF @.NOTE[j].CONT[k].BREAK\n" \
            "<BR>\n" \
          "!ENDIF\n" \
          "${@.NOTE[j].CONT[k].TEXT}\n" \
        "!INCREMENT k\n" \
      "!END\n" \
      "!RESET k\n" \
      "!WHILE @.NOTE[j].SOURCE[k]\n" \
        "<A HREF=\"${@.NOTE[j].SOURCE[k].SOURCE.&}\">[${@.NOTE[j].SOURCE[k].SOURCE.XREF}]</A>\n" \
        "!INCREMENT k\n" \
      "!END\n" \
      "!INCREMENT j\n" \
    "!END\n" \
    "!IF @.SOURCE\n" \
      "<A HREF=\"${@.SOURCE.&}\">[${@.SOURCE.XREF}]</A>\n" \
    "!ENDIF\n" \
    "<P>\n" \
    "!NEXT\n" \
  "!END\n" \
  "<HR><EM>Created by \n" \
  "!VERSION\n" \
  "on \n" \
  "!DATE\n" \
  "</EM>\n" \
  "</BODY>\n</HTML>\n";

char *index_template =
  "<HTML>\n<HEAD>\n<TITLE>" \
  "(${@.PARENT.FIRST.NAME} - ${@.PARENT.LAST.NAME})" \
  "</TITLE>\n</HEAD>\n" \
  "<BODY>\n<H2>Index of Persons</H2>\n" \
  "!WHILE @\n" \
    "!IF @.CHILDREN\n" \
       "<A HREF=\"${@.&}\">\n" \
       "${@.FIRST.NAME} - ${@.LAST.NAME}\n" \
       "</A><BR>\n" \
    "!ELSE\n" \
       "!IF @.FIRST.TITLE\n" \
	 "<A NAME=\"${@.FIRST.XREF}\"></A>\n" \
         "<A HREF=\"${@.FIRST.&}\">" \
         "${@.FIRST.NAME} (${@.FIRST.TITLE})</A>\n" \
       "!ELSE\n" \
	 "<A NAME=\"${@.FIRST.XREF}\"></A>\n" \
         "<A HREF=\"${@.FIRST.&}\">" \
	 "${@.FIRST.NAME}</A>\n" \
       "!ENDIF\n" \
       " (${@.FIRST.BIRTH.DATE}\n" \
/*       "!IF @.FIRST.BIRTH.PLACE.NAME\n" \
         ", ${@.FIRST.BIRTH.PLACE.NAME}\n" \
       "!ENDIF\n" \ */
       " - ${@.FIRST.DEATH.DATE}\n" \
/*       "!IF @.LAST.BIRTH.PLACE.NAME\n" \
         ", ${@.LAST.BIRTH.PLACE.NAME}\n" \
       "!ENDIF\n" \ */
       ")<BR>\n" \
    "!ENDIF\n" \
    "!IF @.NEXT\n" \
    "!ELSE\n" \
      "</P>\n" \
      "!IF @.PARENT\n" \
        "!IF @.PARENT.PARENT\n" \
          "<A HREF=\"${@.PARENT.PARENT.&}\">UP</A> " \
          "(${@.PARENT.PARENT.FIRST.NAME} - ${@.PARENT.PARENT.LAST.NAME}\n" \
          "</A>)<BR>\n" \
        "!ENDIF\n" \
        "!IF @.PARENT.PREV\n" \
          "<A HREF=\"${@.PARENT.PREV.&}\">BACK</A> " \
          "(${@.PARENT.PREV.FIRST.NAME} - ${@.PARENT.PREV.LAST.NAME}\n" \
          "</A>)<BR>\n" \
        "!ENDIF\n" \
        "!IF @.PARENT.NEXT\n" \
          "<A HREF=\"${@.PARENT.NEXT.&}\">NEXT</A> " \
          "(${@.PARENT.NEXT.FIRST.NAME} - ${@.PARENT.NEXT.LAST.NAME}\n" \
          "</A>)<BR>\n" \
        "!ENDIF\n" \
      "!ENDIF\n" \
    "!ENDIF\n" \
    "!NEXT\n" \
  "!END\n" \
  "<P>\n"
#ifdef MSDOS
  "<A HREF=\"surnames.htm\">SURNAMES</A><P>\n"
#else
  "<A HREF=\"SURNAMES.html\">SURNAMES</A><P>\n"
#endif
  "<HR><EM>Created by \n" \
  "!VERSION\n" \
  "on \n" \
  "!DATE\n" \
  "</EM>\n" \
  "</BODY>\n</HTML>\n";

char *surname_template =
  "<HTML>\n<HEAD>\n<TITLE>" \
  "Index of Surnames" \
  "</TITLE>\n</HEAD>\n" \
  "<BODY>\n<H2>Index of Surnames</H2>\n" \
  "!WHILE @\n" \
    "!IF @.NEXT\n" \
      "<A HREF=\"${@.PARENT.&}#${@.FIRST.XREF}\">${@.FIRST.SURNAME}</A>,\n" \
    "!ELSE\n" \
      "<A HREF=\"${@.PARENT.&}#${@.FIRST.XREF}\">${@.FIRST.SURNAME}</A>\n" \
    "!ENDIF\n" \
    "!NEXT\n" \
  "!END\n" \
  "<P>\n" \
  INDEX_ANCHOR_NOSUBDIR \
  "<P><HR><EM>Created by \n" \
  "!VERSION\n" \
  "on \n" \
  "!DATE\n" \
  "</EM>\n" \
  "</BODY>\n</HTML>\n";

